/****** Object:  UserDefinedFunction [dbo].[UFD_BASE_CALC_MP]    Script Date: 18/06/2014 12:20:18 ******/

IF EXISTS
(
    SELECT *
    FROM sys.objects
    WHERE object_id = OBJECT_ID(N'[dbo].[UFD_BASE_CALC_MP]')
          AND type IN(N'FN', N'IF', N'TF', N'FS', N'FT')
)
    DROP FUNCTION [dbo].[UFD_BASE_CALC_MP];
GO
GO
GO
GO

/*  
 Gera base de calculo para o Mapa Resumo  
  
 EMPRESA: CORPORATE BUSINES  
 DATA INICIO:  15/12/2003  
 DATA TERMINO: 15/12/2003   
 PROFISSIONAL: Allysson  
*/

--SELECT * FROM UFD_BASE_CALC_MP(1,'1,2','2004-04-01','2004-04-30')  


CREATE FUNCTION [dbo].[UFD_BASE_CALC_MP]
(  
--CREATE FUNCTION UFD_BASE_CALC_MP(  
@CD_EMP    INT,
@CD_FILIAL VARCHAR(3000),
@DT_INI    DATETIME,
@DT_FIM    DATETIME
)
RETURNS @RS_TEMP TABLE
(CD_EMP    INT,
 CD_FILIAL INT,
 CD_CTR    INT,
 CD_CX     INT,
 DT_ECP    DATETIME,
 ALIQ07    MONEY,
 ALIQ12    MONEY,
 ALIQ17    MONEY,
 ALIQ20    MONEY,
 ALIQ25    MONEY,
 ALIQ18    MONEY,
 ALIQ19    MONEY,
 VLR_ISSQN MONEY
)
AS
     BEGIN
         DECLARE @RS_MP_ALIQ TABLE
         (CD_EMP    INT,
          CD_FILIAL INT,
          CD_CTR    INT,
          CD_CX     INT,
          DT_ECP    DATETIME,
          ALIQ07    MONEY,
          ALIQ12    MONEY,
          ALIQ17    MONEY,
          ALIQ20    MONEY,
          ALIQ25    MONEY,
          ALIQ18    MONEY,
          ALIQ19    MONEY,
          VLR_ISSQN MONEY
         );
         DECLARE @TBL_FILIAL TABLE
         (CD_EMP    INT,
          CD_FILIAL INT
         );
         INSERT INTO @TBL_FILIAL
                SELECT CD_EMP
                     , CD_FILIAL
                FROM PRC_FILIAL
                WHERE CD_EMP = @CD_EMP
                      AND CD_FILIAL IN
                (
                    SELECT ID
                    FROM UFD_PRM_IN_STRING(@CD_FILIAL)
                );
         INSERT INTO @RS_MP_ALIQ
         (CD_EMP
        , CD_FILIAL
        , CD_CTR
        , CD_CX
        , DT_ECP
        , ALIQ07
        , ALIQ12
        , ALIQ17
        , ALIQ20
        , ALIQ25
        , ALIQ18
        , ALIQ19
        , VLR_ISSQN
         )
                SELECT DISTINCT
                       PDV_MAPA_RESUMO.CD_EMP
                     , PDV_MAPA_RESUMO.CD_FILIAL
                     , PDV_MAPA_RESUMO.CD_CTR
                     , PDV_MAPA_RESUMO.CD_CX
                     , PDV_MAPA_RESUMO.DT_ECF
                     , 0
                     , 0
                     , 0
                     , 0
                     , 0
                     , 0
                     , 0
                     , 0
                FROM
                     PDV_MAPA_RESUMO
                     INNER JOIN @TBL_FILIAL FL
                     ON PDV_MAPA_RESUMO.CD_EMP = FL.CD_EMP
                        AND PDV_MAPA_RESUMO.CD_FILIAL = FL.CD_FILIAL
                WHERE PDV_MAPA_RESUMO.DT_ECF BETWEEN @DT_INI AND @DT_FIM
                ORDER BY PDV_MAPA_RESUMO.CD_CX
                       , PDV_MAPA_RESUMO.DT_ECF;
         UPDATE @RS_MP_ALIQ
           SET
               ALIQ07 = BASE_CALC
         FROM PDV_MAPA_RESUMO, PDV_MAPA_RESUMO_CPL, @RS_MP_ALIQ RS_MP_ALIQ, @TBL_FILIAL FL
         WHERE PDV_MAPA_RESUMO.CD_EMP = PDV_MAPA_RESUMO_CPL.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = PDV_MAPA_RESUMO_CPL.CD_FILIAL
               AND PDV_MAPA_RESUMO.CD_CTR = PDV_MAPA_RESUMO_CPL.CD_CTR
               AND PDV_MAPA_RESUMO.CD_EMP = RS_MP_ALIQ.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = RS_MP_ALIQ.CD_FILIAL
               AND PDV_MAPA_RESUMO.CD_CTR = RS_MP_ALIQ.CD_CTR
               AND PDV_MAPA_RESUMO.CD_EMP = FL.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = FL.CD_FILIAL
               AND PDV_MAPA_RESUMO.DT_ECF BETWEEN @DT_INI AND @DT_FIM
               AND PDV_MAPA_RESUMO_CPL.TX_ICMS = 07;
         UPDATE @RS_MP_ALIQ
           SET
               ALIQ12 = BASE_CALC
         FROM PDV_MAPA_RESUMO, PDV_MAPA_RESUMO_CPL, @RS_MP_ALIQ RS_MP_ALIQ, @TBL_FILIAL FL
         WHERE PDV_MAPA_RESUMO.CD_EMP = PDV_MAPA_RESUMO_CPL.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = PDV_MAPA_RESUMO_CPL.CD_FILIAL
               AND PDV_MAPA_RESUMO.CD_CTR = PDV_MAPA_RESUMO_CPL.CD_CTR
               AND PDV_MAPA_RESUMO.CD_EMP = RS_MP_ALIQ.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = RS_MP_ALIQ.CD_FILIAL
               AND PDV_MAPA_RESUMO.CD_CTR = RS_MP_ALIQ.CD_CTR
               AND PDV_MAPA_RESUMO.CD_EMP = FL.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = FL.CD_FILIAL
               AND PDV_MAPA_RESUMO.DT_ECF BETWEEN @DT_INI AND @DT_FIM
               AND PDV_MAPA_RESUMO_CPL.TX_ICMS = 12;
         UPDATE @RS_MP_ALIQ
           SET
               ALIQ17 = BASE_CALC
         FROM PDV_MAPA_RESUMO, PDV_MAPA_RESUMO_CPL, @RS_MP_ALIQ RS_MP_ALIQ, @TBL_FILIAL FL
         WHERE PDV_MAPA_RESUMO.CD_EMP = PDV_MAPA_RESUMO_CPL.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = PDV_MAPA_RESUMO_CPL.CD_FILIAL
               AND PDV_MAPA_RESUMO.CD_CTR = PDV_MAPA_RESUMO_CPL.CD_CTR
               AND PDV_MAPA_RESUMO.CD_EMP = RS_MP_ALIQ.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = RS_MP_ALIQ.CD_FILIAL
               AND PDV_MAPA_RESUMO.CD_CTR = RS_MP_ALIQ.CD_CTR
               AND PDV_MAPA_RESUMO.CD_EMP = FL.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = FL.CD_FILIAL
               AND PDV_MAPA_RESUMO.DT_ECF BETWEEN @DT_INI AND @DT_FIM
               AND PDV_MAPA_RESUMO_CPL.TX_ICMS = 17;
         UPDATE @RS_MP_ALIQ
           SET
               ALIQ20 = BASE_CALC
         FROM PDV_MAPA_RESUMO, PDV_MAPA_RESUMO_CPL, @RS_MP_ALIQ RS_MP_ALIQ, @TBL_FILIAL FL
         WHERE PDV_MAPA_RESUMO.CD_EMP = PDV_MAPA_RESUMO_CPL.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = PDV_MAPA_RESUMO_CPL.CD_FILIAL
               AND PDV_MAPA_RESUMO.CD_CTR = PDV_MAPA_RESUMO_CPL.CD_CTR
               AND PDV_MAPA_RESUMO.CD_EMP = RS_MP_ALIQ.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = RS_MP_ALIQ.CD_FILIAL
               AND PDV_MAPA_RESUMO.CD_CTR = RS_MP_ALIQ.CD_CTR
               AND PDV_MAPA_RESUMO.CD_EMP = FL.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = FL.CD_FILIAL
               AND PDV_MAPA_RESUMO.DT_ECF BETWEEN @DT_INI AND @DT_FIM
               AND PDV_MAPA_RESUMO_CPL.TX_ICMS = 20;
         UPDATE @RS_MP_ALIQ
           SET
               ALIQ25 = BASE_CALC
         FROM PDV_MAPA_RESUMO, PDV_MAPA_RESUMO_CPL, @RS_MP_ALIQ RS_MP_ALIQ, @TBL_FILIAL FL
         WHERE PDV_MAPA_RESUMO.CD_EMP = PDV_MAPA_RESUMO_CPL.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = PDV_MAPA_RESUMO_CPL.CD_FILIAL
               AND PDV_MAPA_RESUMO.CD_CTR = PDV_MAPA_RESUMO_CPL.CD_CTR
               AND PDV_MAPA_RESUMO.CD_EMP = RS_MP_ALIQ.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = RS_MP_ALIQ.CD_FILIAL
               AND PDV_MAPA_RESUMO.CD_CTR = RS_MP_ALIQ.CD_CTR
               AND PDV_MAPA_RESUMO.CD_EMP = FL.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = FL.CD_FILIAL
               AND PDV_MAPA_RESUMO.DT_ECF BETWEEN @DT_INI AND @DT_FIM
               AND PDV_MAPA_RESUMO_CPL.TX_ICMS = 25;
         UPDATE @RS_MP_ALIQ
           SET
               ALIQ18 = BASE_CALC
         FROM PDV_MAPA_RESUMO, PDV_MAPA_RESUMO_CPL, @RS_MP_ALIQ RS_MP_ALIQ, @TBL_FILIAL FL
         WHERE PDV_MAPA_RESUMO.CD_EMP = PDV_MAPA_RESUMO_CPL.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = PDV_MAPA_RESUMO_CPL.CD_FILIAL
               AND PDV_MAPA_RESUMO.CD_CTR = PDV_MAPA_RESUMO_CPL.CD_CTR
               AND PDV_MAPA_RESUMO.CD_EMP = RS_MP_ALIQ.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = RS_MP_ALIQ.CD_FILIAL
               AND PDV_MAPA_RESUMO.CD_CTR = RS_MP_ALIQ.CD_CTR
               AND PDV_MAPA_RESUMO.CD_EMP = FL.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = FL.CD_FILIAL
               AND PDV_MAPA_RESUMO.DT_ECF BETWEEN @DT_INI AND @DT_FIM
               AND PDV_MAPA_RESUMO_CPL.TX_ICMS = 18;
         UPDATE @RS_MP_ALIQ
           SET
               ALIQ19 = BASE_CALC
         FROM PDV_MAPA_RESUMO, PDV_MAPA_RESUMO_CPL, @RS_MP_ALIQ RS_MP_ALIQ, @TBL_FILIAL FL
         WHERE PDV_MAPA_RESUMO.CD_EMP = PDV_MAPA_RESUMO_CPL.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = PDV_MAPA_RESUMO_CPL.CD_FILIAL
               AND PDV_MAPA_RESUMO.CD_CTR = PDV_MAPA_RESUMO_CPL.CD_CTR
               AND PDV_MAPA_RESUMO.CD_EMP = RS_MP_ALIQ.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = RS_MP_ALIQ.CD_FILIAL
               AND PDV_MAPA_RESUMO.CD_CTR = RS_MP_ALIQ.CD_CTR
               AND PDV_MAPA_RESUMO.CD_EMP = FL.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = FL.CD_FILIAL
               AND PDV_MAPA_RESUMO.DT_ECF BETWEEN @DT_INI AND @DT_FIM
               AND PDV_MAPA_RESUMO_CPL.TX_ICMS = 19;
         UPDATE @RS_MP_ALIQ
           SET
               VLR_ISSQN = BASE_CALC
         FROM PDV_MAPA_RESUMO, PDV_MAPA_RESUMO_CPL, @RS_MP_ALIQ RS_MP_ALIQ, @TBL_FILIAL FL
         WHERE PDV_MAPA_RESUMO.CD_EMP = PDV_MAPA_RESUMO_CPL.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = PDV_MAPA_RESUMO_CPL.CD_FILIAL
               AND PDV_MAPA_RESUMO.CD_CTR = PDV_MAPA_RESUMO_CPL.CD_CTR
               AND PDV_MAPA_RESUMO.CD_EMP = RS_MP_ALIQ.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = RS_MP_ALIQ.CD_FILIAL
               AND PDV_MAPA_RESUMO.CD_CTR = RS_MP_ALIQ.CD_CTR
               AND PDV_MAPA_RESUMO.CD_EMP = FL.CD_EMP
               AND PDV_MAPA_RESUMO.CD_FILIAL = FL.CD_FILIAL
               AND PDV_MAPA_RESUMO.DT_ECF BETWEEN @DT_INI AND @DT_FIM
               AND PDV_MAPA_RESUMO_CPL.TIPO_IMPOSTO = 1;
         INSERT INTO @RS_TEMP
                SELECT *
                FROM @RS_MP_ALIQ;
         RETURN;
     END;  
  
--SELECT * FROM UFD_BASE_CALC_MP(1,4,'20160606','20160606')
GO